@extends('layouts.master')

@section('title')
    Ganti Kartu Member
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Ganti Kartu Member</li>
@endsection
<style>
  :root {
      --primary-color: rgb(11, 78, 179)
  }

  *,
  *::before,
  *::after {
      box-sizing: border-box
  }

  body {
      font-family: Montserrat, "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
      margin: 0;
      display: grid;
    
      min-height: 100vh;
      background-color: #0b4eb3
  }

  label {
      display: block;
      margin-bottom: 0.5rem
  }

  input {
      display: block;
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 0.25rem;
      height: 50px
  }
  select {
      display: block;
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 0.25rem;
      height: 50px
  }
  textarea {
      display: block;
      width: 100%;
      padding: 0.75rem;
      border: 1px solid #ccc;
      border-radius: 0.25rem;
      height: 50px
  }

  .width-50 {
      width: 50%
  }

  .ml-auto {
      margin-left: auto
  }

  .text-center {
      text-align: center
  }

  .progressbar {
      position: relative;
      display: flex;
      justify-content: space-between;
      counter-reset: step;
      margin: 2rem 0 4rem
  }

  .progressbar::before,
  .progress {
      content: "";
      position: absolute;
      top: 50%;
      transform: translateY(-50%);
      height: 4px;
      width: 100%;
      background-color: #dcdcdc;
      z-index: 1
  }

  .progress {
      background-color: rgb(0 128 0);
      width: 0%;
      transition: 0.3s;
      height:6px ;
  }

  .progress-step {
      width: 2.1875rem;
      height: 2.1875rem;
      background-color: #dcdcdc;
      border-radius: 50%;
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 1
  }

  .progress-step::before {
      counter-increment: step;
      content: counter(step)
  }

  .progress-step::after {
      content: attr(data-title);
      position: absolute;
      top: calc(100% + 0.5rem);
      font-size: 0.85rem;
      color: #666;
  }

  .progress-step-active {
      background-color: var(--primary-color);
      color: #f3f3f3
  }

  .form {
      width: clamp(320px, 30%, 430px);
      margin: 0 auto;
      border: none;
      border-radius: 10px !important;
      overflow: hidden;
      padding: 1.5rem;
      background-color: #fff;
      padding: 20px 30px
  }

  .step-forms {
      display: none;
      transform-origin: top;
      animation: animate 1s
  }

  .step-forms-active {
      display: block
  }

  .group-inputs {
      margin: 1rem 0
  }

  @keyframes animate {
      from {
          transform: scale(1, 0);
          opacity: 0
      }

      to {
          transform: scale(1, 1);
          opacity: 1
      }
  }

  .btns-group {
      display: grid;
      grid-template-columns: repeat(2, 1fr);
      gap: 1.5rem
  }

  .btn {
      padding: 0.75rem;
      display: block;
      text-decoration: none;
      background-color: var(--primary-color);
      color: #f3f3f3;
      text-align: center;
      border-radius: 0.25rem;
      cursor: pointer;
      transition: 0.3s
  }

  .btn:hover {
      box-shadow: 0 0 0 2px #fff, 0 0 0 3px var(--primary-color)
  }

  .progress-step-check {
      position: relative;
      background-color: green !important;
      transition: all 0.8s;
      /* height: 4px; */
  }

  .progress-step-check::before {
      position: absolute;
      content: '\2713';
      width: 100%;
      height: 100%;
      top: 3px;
      left: 7px;
      font-size: 12px;
  }

  .group-inputs {
      position: relative
  }

  .group-inputs label {
      font-size: 13px;
      position: absolute;
      height: 19px;
      padding: 4px 7px;
      top: -14px;
      left: 10px;
      color: #a2a2a2;
      background-color: white
  }


  .welcome {
      height: 450px;
      width: 350px;
      background-color: #fff;
      border-radius: 6px;
      display: flex;
      justify-content: center;
      align-items: center
  }

  .welcome .content {
      display: flex;
      align-items: center;
      flex-direction: column
  }

  .checkmark__circle {
      stroke-dasharray: 166;
      stroke-dashoffset: 166;
      stroke-width: 2;
      stroke-miterlimit: 10;
      stroke: #7ac142;
      fill: none;
      animation: stroke 0.6s cubic-bezier(0.65, 0, 0.45, 1) forwards
  }

  .checkmark {
      width: 56px;
      height: 56px;
      border-radius: 50%;
      display: block;
      stroke-width: 2;
      stroke: #fff;
      stroke-miterlimit: 10;
      margin: 10% auto;
      box-shadow: inset 0px 0px 0px #7ac142;
      animation: fill .4s ease-in-out .4s forwards, scale .3s ease-in-out .9s both
  }

  .checkmark__check {
      transform-origin: 50% 50%;
      stroke-dasharray: 48;
      stroke-dashoffset: 48;
      animation: stroke 0.3s cubic-bezier(0.65, 0, 0.45, 1) 0.8s forwards
  }

  @keyframes stroke {
      100% {
          stroke-dashoffset: 0
      }
  }

  @keyframes scale {

      0%,
      100% {
          transform: none
      }

      50% {
          transform: scale3d(1.1, 1.1, 1)
      }
  }

  @keyframes fill {
      100% {
          box-shadow: inset 0px 0px 0px 30px #7ac142
      }
  }
</style>
@section('content')
<form action="{{ route('member.updated_profil', $member->id_member) }}" class="form" id="forms" style="width:75%;" method="post">
   @csrf
  @method('PUT')
    
    <input type="hidden" class="form-control" id="role" name="role" value={{auth()->user()->name}}>
    <input type="hidden" class="form-control" id="tgl_masuk" name="tgl_masuk" value={{$date}}>
    <input type="hidden" class="form-control" id="status" name="status" value="GANTI KARTU">
    <input type="hidden" class="form-control" id="id_member" name="id_member" value={{$member->id_member}}>
    <div class="progressbar">
        <div class="progress" id="progress" style="height: 6px; background-color:green;"></div>
        <div class="progress-step progress-step-active" data-title="Profil Anggota"></div>
        <div class="progress-step" data-title="Pembayaran"></div>
    </div>
<div class="step-forms step-forms-active">
    <h2>Profile Member</h2>
    <h4 style="color: black;">*  Wajib di isi</h4>
    <div class="row">
      {{-- <div class="col-sm-6">
        <div class="group-inputs"> <label for="kode_member">Kode Member *</label> <input type="text" name="kode_member" id="kode_member" value="{{old('kode_member',$member->kode_member)}}"></div>
            @if($errors->has('kode_member'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('kode_member') }}</span>
            @endif
      </div> --}}
      <div class="col-sm-6">
        <div class="group-inputs"> <label for="nama">Nama Lengkap *</label> <input type="text" name="nama" id="nama"  value="{{old('nama',$member->nama)}}"> </div>
            @if($errors->has('nama'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('nama') }}</span>
            @endif
        </div>
        <div class="col-sm-6">
        <div class="group-inputs"> <label for="nama">Kode Member *</label> <textarea name="kode_member" id="kode_member" >{{old('kode_member')}}</textarea> </div>
            @if($errors->has('kode_member'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('kode_member') }}</span>
            @endif
        </div>
    </div>  


    <div class="row">
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="ttl">Tempat Tanggal Lahir *</label> <input type="text" name="ttl" id="ttl"  value="{{old('ttl',$member->ttl)}}" placeholder="Contoh: Malang 9 September"> </div>
            @if($errors->has('ttl'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('ttl') }}</span>
            @endif
        </div>
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="alamat">Alamat Rumah *</label> <textarea name="alamat" id="alamat"> {{old('alamat',$member->alamat)}}</textarea></div>
            @if($errors->has('alamat'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('alamat') }}</span>
            @endif
        </div>
    </div>
    <div class="row">
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="telepon">Telepon *</label> <input type="text" name="telepon" id="telepon"  value="{{old('telepon',$member->telepon)}}"> </div>
            @if($errors->has('telepon'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('telepon') }}</span>
            @endif
        </div>
          <div class="col-sm-6">
            <div class="group-inputs"> <label for="telepon_darurat">Telepon Darurat *</label> <input type="text" name="telepon_darurat" id="telepon_darurat"  value="{{old('telepon_darurat',$member->telepon_darurat)}}"> </div>
             @if($errors->has('telepon_darurat'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('telepon_darurat') }}</span>
            @endif
        </div>
    </div>
    <div class="row">
         <div class="col-sm-6">
            <div class="group-inputs"> <label for="no_ktp">Nomer KTP *</label> <input type="text" name="no_ktp" id="no_ktp"  value="{{old('no_ktp',$member->no_ktp)}}"> </div>
            @if($errors->has('no_ktp'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('no_ktp') }}</span>
            @endif
        </div>
          <div class="col-sm-6">
            <div class="group-inputs"> <label for="gender">Gender *</label> <select  name="gender" id="gender">
                 <option value="" disabled selected style="color: lightgrey;">Gender</option>
                <option value="L" @if (old('gender') == "L") {{ 'selected' }} @endif {{ $member->gender == 'L' ? 'selected' : '' }}>Laki-Laki</option>
                <option value="P" @if (old('gender') == "P") {{ 'selected' }} @endif {{ $member->gender == 'P' ? 'selected' : '' }}>Perempuan</option>
                </select>
                @if($errors->has('gender'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('gender') }}</span>
                @endif
            </div>
        </div>
    </div>
    <div class="row">
         <div class="col-sm-6">
              <div class="group-inputs"> <label for="sosmed">Sosmed</label> <input type="text" name="sosmed" id="sosmed"  value="{{old('sosmed',$member->sosmed)}}"> </div>
         </div>
          <div class="col-sm-6">
            <div class="group-inputs"> <label for="email">Email *</label> <input type="email" name="email" id="email"  value="{{old('email', $member->email)}}"> </div>
            @if($errors->has('email'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('email') }}</span>
            @endif
        </div>  
    </div>
    <div class="row">
         <div class="col-sm-12">
            <div class="group-inputs"> <label for="alamat_kantor">Alamat Kantor *</label> <textarea name="alamat_kantor" id="alamat_kantor" >{{old('alamat_kantor',$member->alamat_kantor)}}</textarea> </div>
            @if($errors->has('alamat_kantor'))
                <span class="invalid-feedback" style="color:red;">{{ $errors->first('alamat_kantor') }}</span>
            @endif
        </div>
    </div>
        <div class="" style="text-align: center;"> <a href="#" class="btn btn-next width-50 ml-auto">Next</a> </div>
    </div>
    <div class="perhitungan">
        <div class="step-forms">
            <h2  style="margin-bottom: 16px;">Pembayaran</h2>
                
            
             <div class="row">
                <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Harga Ganti Kartu *</label> <input type="text" name="total" id="total"class="hasil" value="{{old('hasil')}}"> 
                        @if($errors->has('total'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('total') }}</span>
                        @endif
                    </div>
                </div>
                  <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Tanggal Pembayaran *</label> <input type="text" name="tanggal_bayar2" id="tanggal_bayar2" readonly value="{{$date}}" />
                        @if($errors->has('tanggal_bayar2'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('tanggal_bayar2') }}</span>
                        @endif
                    </div>
                  </div>
             </div>

              <div class="row" hidden>
                <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Bayar *</label> <input type="text" name="harus_bayar" id="harus_bayar"class="bil5" value="{{old('hasil')}}"> 
                        @if($errors->has('harus_bayar'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('harus_bayar') }}</span>
                        @endif
                    </div>
                </div>
                  <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Sisa *</label> <input type="text" name="sisa" id="sisa" class="sisa" readonly />
                        @if($errors->has('sisa'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('sisa') }}</span>
                        @endif
                    </div>
                  </div>
             </div>
             

            {{-- <div class="row">
                <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Jenis Pembayaran *</label>
                         <select name="jenis_pembayaran_pribadi" id="jenis_pembayaran_pribadi" >
                        <option value="" disabled selected>Pilih Pembayaran</option>
                        <option value="Cash"  @if (old('jenis_pembayaran_pribadi') == "Cash") {{ 'selected' }} @endif>Cash</option>
                        <option value="Debit"  @if (old('jenis_pembayaran_pribadi') == "Debit") {{ 'selected' }} @endif>Debit</option>
                        <option value="Credit Card"  @if (old('jenis_pembayaran_pribadi') == "Credit Card") {{ 'selected' }} @endif>Credit Card</option>
                        <option value="Tranfer"  @if (old('jenis_pembayaran_pribadi') == "Tranfer") {{ 'selected' }} @endif>Transfer</option>
                        <option value="QRIS"  @if (old('jenis_pembayaran_pribadi') == "QRIS") {{ 'selected' }} @endif>QRIS</option>
                        </select>
                        @if($errors->has('jenis_pembayaran_pribadi'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('jenis_pembayaran_pribadi') }}</span>
                        @endif
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Nama Bank </label> <input type="text" name="nama_bank" id="nama_bank" value="{{old('nama_bank')}}" />
                        @if($errors->has('nama_bank'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('nama_bank') }}</span>
                        @endif
                    </div>
                </div>
             </div>
             <div class="row">
                  <div class="col-sm-12">
                    <div class="group-inputs"> <label for="ID">Catatan </label> <textarea name="catatan" id="catatan"  >{{old('catatan')}}</textarea>
                        @if($errors->has('catatan'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('catatan') }}</span>
                        @endif
                    </div>
                </div> --}}

                {{-- <div class="col-sm-6">
                    <div class="group-inputs"> <label for="ID">Catatan Utang </label> <textarea name="catatan_utang" id="catatan_utang" placeholder="Detail utang jika ada">{{old('catatan_utang')}}</textarea>
                        @if($errors->has('catatan_utang'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('catatan_utang') }}</span>
                        @endif
                    </div>
                </div> --}}
             {{-- </div> --}}
             {{-- <div class="row">
                <div class="col-sm-6">
                     <div class="group-inputs"> <label for="nama_staff">Nama Staff</label>
                        <select name="nama_staff" id="nama_staff">
                        <option value="" disabled selected>Pilih Staff </option>
                            @foreach ($staff as $n)
                                <option value="{{ $n->nama_pegawai}}"{{old('nama_staff') == $n->nama_pegawai ? 'selected' : ''}}>{{ $n->nama_pegawai }}</option>
                            @endforeach
                        </select> 
                        @if($errors->has('nama_staff'))
                            <span class="invalid-feedback" style="color:red;">{{ $errors->first('nama_staff') }}</span>
                        @endif
                    </div>
                </div>     
            </div>     --}}
            <div class="btns-group"> 
                <a href="#" class="btn btn-prev">Previous</a> 
                <button type="submit" class="btn btn-info pull-right">Simpan</button></div>
        </div>
    </div>
   
</form>
  @endsection
 
  @push('scripts')

  <script type="text/javascript" src="{{asset('js/jquery-3.6.0.min.js')}}"></script>
  <script src ="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.13.14/dist/js/bootstrap-select.min.js"></script>
  <script >
     $( document ).ready(function() {
              $( ".target" ).change(function() {
                var id = $(this).val();
                // var nama = $(this).find('nama_supplier');
                // console.log(nama);
                $.ajax({
                    type: 'get',
                    url: '{{ route('layanan.ambil.data')}}',
                    data: {
                        layanan_id: JSON.stringify($('.layanan_id').val())
                    },
                    success: function(response) 
                    {
                        console.log(response);
                        $('.harga').val(response[0].harga);
                        
                    },
                    error: function(response) {
                        alert(response.responseJSON.message);
                    }
                });
              });

                $( ".target2" ).change(function() {
                var id = $(this).val();
                // var nama = $(this).find('nama_supplier');
                // console.log(nama);
                $.ajax({
                    type: 'get',
                    url: '{{ route('layanan.ambil.data2')}}',
                    data: {
                        iseng: JSON.stringify($('.layanan_id2').val())
                    },
                    success: function(response) 
                    {
                        console.log(response);
                        $('.harga_personal').val(response[0].harga);
                        
                    },
                    error: function(response) {
                        alert(response.responseJSON.message);
                    }
                });
              });


        $(".perhitungan").keyup(function(){
          var bil3 = parseInt($(".bil3").val())
          var bil4 = parseInt($(".bil4").val())
    
          var hasil =  bil3 + bil4;
          if(hasil > 0) {
          $(".hasil").attr("value",hasil)
          }else{
            $(".hasil").attr("value",0)
          }
        });
        const prevBtns = document.querySelectorAll(".btn-prev");
const nextBtns = document.querySelectorAll(".btn-next");
const progress = document.getElementById("progress");
const formSteps = document.querySelectorAll(".step-forms");
const progressSteps = document.querySelectorAll(".progress-step");


let formStepsNum = 0;

nextBtns.forEach((btn) => {
btn.addEventListener("click", () => {
formStepsNum++;
updateFormSteps();
updateProgressbar();

});
});

prevBtns.forEach((btn) => {
btn.addEventListener("click", () => {
formStepsNum--;
updateFormSteps();
updateProgressbar();

});
});

function updateFormSteps() {
formSteps.forEach((formStep) => {
formStep.classList.contains("step-forms-active") &&
formStep.classList.remove("step-forms-active");
});

formSteps[formStepsNum].classList.add("step-forms-active");
}

function updateProgressbar() {
    progressSteps.forEach((progressStep, idx) => {
    if (idx < formStepsNum + 1) { progressStep.classList.add("progress-step-active"); } else { progressStep.classList.remove("progress-step-active"); } }); progressSteps.forEach((progressStep, idx)=> {
        if (idx < formStepsNum) { progressStep.classList.add("progress-step-check"); } else { progressStep.classList.remove("progress-step-check"); } }); const progressActive=document.querySelectorAll(".progress-step-active"); progress.style.width=((progressActive.length - 1) / (progressSteps.length - 1)) * 100 + "%" ; } document.getElementById("submit-form").addEventListener("click", function () { progressSteps.forEach((progressStep, idx)=> {
            if (idx <= formStepsNum) { progressStep.classList.add("progress-step-check"); } else { progressStep.classList.remove("progress-step-check"); } }); var forms=document.getElementById("forms"); forms.classList.remove("form"); forms.innerHTML='<div class="welcome"><div class="content"><svg class="checkmark" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 52 52"><circle class="checkmark__circle" cx="26" cy="26" r="25" fill="none"/><path class="checkmark__check" fill="none" d="M14.1 27.2l7.1 7.2 16.7-16.8"/></svg><h2>Thanks for signup!</h2><span>We will contact you soon!</span><div></div>' ; });
});
  </script>
  @endpush
 
