@extends('layouts.master')

@section('title')
    Daftar Member
@endsection

@section('breadcrumb')
    @parent
    <li class="active">Daftar Member</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="box">
            <!-- <div class="box-header with-border">
                <button onclick="addForm('{{ route('member.store') }}')" class="btn btn-success btn-xs btn-flat"><i class="fa fa-plus-circle"></i> Tambah</button>
                
            </div> -->
             {{-- <button onclick="cetakMember('{{ route('member.cetak_member') }}')" class="btn btn-info btn-xs btn-flat"><i class="fa fa-id-card"></i> Cetak Member</button> --}}
            <div class="box-body table-responsive">
                <form action="" method="post" class="form-member">
                    @csrf
                    <table class="table table-stiped table-bordered table-penjualan" id="table-member">
                        <thead>
                              {{-- <th width="5%">
                                <input type="checkbox" name="select_all" id="select_all">
                            </th> --}}
                            <th width="5%">No</th>
                            <th>Kode</th>
                            <th>Nama</th>      
                            <th>Status Member</th>
                            <th>Status PT</th>
                            <th>PT</th>
                            <th><i class="fa fa-cog"></i></th>
                        </thead>
                    </table>
                </form>
            </div>
        </div>
    </div>
</div>

@includeIf('member.detail_member')
@endsection

@push('scripts')
<script>
    let table, table1;

    $(function () {
        table = $('#table-member').DataTable({
            processing: true,
            autoWidth: false,
            //  scrollX: false,
            //  scrollY: false,
            ajax: {
                url: '{{ route('member.data') }}',
            },
            columns: [
                // {data: 'select_all', searchable: false, sortable: false},
                {data: 'DT_RowIndex', searchable: false, sortable: false},
                {data: 'kode_member'},              
                {data: 'nama'},               
                {data: 'status'}, 
                {data: 'status2'},
                {data: 'id_instruktur'},
                {data: 'aksi', searchable: false, sortable: false},
            ]
        });
       table1 = $('#table_detail').DataTable({
            processing: true,
            bSort: false,
            paging: false,
            searching:false,
            columns: [
                {data: 'nama_paket'},
                {data: 'tgl_masuk'},
                {data: 'exp_date'},      
                {data: 'nama_paket2'},
                {data: 'tgl_masuk2'},
                {data: 'exp_date2'},     
            ]
        });
    });
    function showDetail10(url) {
        $('#modal123').modal('show');
          table1.ajax.url(url);
          table1.ajax.reload();
    }

    function deleteData(url) {
        if (confirm('Yakin ingin menghapus data terpilih?')) {
            $.post(url, {
                    '_token': $('[name=csrf-token]').attr('content'),
                    '_method': 'delete'
                })
                .done((response) => {
                    table.ajax.reload();
                })
                .fail((errors) => {
                    alert('Tidak dapat menghapus data');
                    return;
                });
        }
    }
     function cetakMember(url) {
        if ($('input:checked').length < 1) {
            alert('Pilih data yang akan dicetak');
            return;
        } else {
            $('.form-member')
                .attr('target', '_blank')
                .attr('action', url)
                .submit();
        }
    }
</script>
@endpush