<?php

namespace App\Http\Controllers;

use App\Models\Pembelian;
use App\Models\Pengeluaran;
use App\Models\Penjualan;
use App\Models\TotalKeseluruhan;
use App\Models\PembelianGym;
use App\Models\PenjualanDetail;
use Illuminate\Http\Request;
use PDF;
use DB;
use Carbon\Carbon;

class LaporanController extends Controller
{
    public function index(Request $request)
    {
        $tanggalAwal = date('Y-m-d', mktime(0, 0, 0, date('m'), 1, date('Y')));
        $tanggalAkhir = date('Y-m-d');

        if ($request->has('tanggal_awal') && $request->tanggal_awal != "" && $request->has('tanggal_akhir') && $request->tanggal_akhir) {
            $tanggalAwal = $request->tanggal_awal;
            $tanggalAkhir = $request->tanggal_akhir;
        }

        return view('laporan.index', compact('tanggalAwal', 'tanggalAkhir'));
    }

    public function getData($awal, $akhir)
    {
        $no = 1;
        $data = array();
        $pendapatan = 0;
        $total_pendapatan = 0;

        while (strtotime($awal) <= strtotime($akhir)) {
            $tanggal = $awal;
            $awal = date('Y-m-d', strtotime("+1 day", strtotime($awal)));

            $total_penjualan = PenjualanDetail::where('created_at', 'LIKE', "%$tanggal%")->sum('subtotal');
            $total_penjualan2 = Penjualan::where('created_at', 'LIKE', "%$tanggal%")->sum('total_harga');
            
            $total_member = TotalKeseluruhan::where('created_at', 'LIKE', "%$tanggal%")->sum('total');
           
            //  dd($ganti_kartu);
            $total_pengeluaran = PembelianGym::where('created_at', 'LIKE', "%$tanggal%")->sum('total');

            $total_penjualan_karo_member = $total_penjualan + $total_member;
            // $total_pembelian = Pembelian::where('created_at', 'LIKE', "%$tanggal%")->sum('bayar');

            $pendapatan =  $total_penjualan_karo_member - $total_pengeluaran;
            $total_pendapatan += $pendapatan;

            $row = array();
            $row['DT_RowIndex'] = $no++;
            $row['tanggal'] = tanggal_indonesia($tanggal, false);
            $row['penjualan'] = format_uang($total_penjualan_karo_member);
            $row['pembelian'] = format_uang($total_pengeluaran);
            $row['pendapatan'] = format_uang($pendapatan);
            
            $data[] = $row;
        }

        $data[] = [
            'DT_RowIndex' => '',
            'tanggal' => '',
            'penjualan' => '',
            'pembelian' => '',
            'pengeluaran' => 'Balance ',
            'pendapatan' => format_uang($total_pendapatan),
           
        ];
       
         return $data;
    }
    public function detail_pendapatan()
    {
          $pendaftaran = DB::table('member')
            ->join('total_keseluruhan', 'total_keseluruhan.id_member', '=', 'member.id_member')
            ->select('total_keseluruhan.*','nama', 'total_keseluruhan.total','member.role')
            ->where('total_keseluruhan.created_at', '>=', Carbon::today())
            // ->where('total_keseluruhan.role',$auth)
            ->get();
        return view('laporan.detail_pendapatan',compact('pendaftaran'));
    }
    public function data($awal, $akhir)
    {
     
        $data = $this->getData($awal, $akhir);
        
        return datatables()
            ->of($data)
            ->make(true);
    }
    

    public function exportPDF($awal, $akhir)
    {
        $data = $this->getData($awal, $akhir);
        $pdf  = PDF::loadView('laporan.pdf', compact('awal', 'akhir', 'data'));
        $pdf->setPaper('a4', 'potrait');
        
        return $pdf->stream('Laporan-pendapatan-'. date('Y-m-d-his') .'.pdf');
    }
}
