<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Hadir;
use App\Models\Member;
use Redirect,Response;
class HadirController extends Controller
{
    public function index()
    {
        
        // dd($timestamp);
        return view('hadir.index');
    }
    public function data()
    {
        $hadir = Hadir::orderBy('id', 'desc')->get();

        return datatables()
            ->of($hadir)
            ->addIndexColumn()
            ->addColumn('tanggal', function ($hadir) {
                     return tanggal_indonesia($hadir->tanggal, false);
                 })
            ->rawColumns(['aksi','tanggal'])
            ->make(true);
    }

    public function store(Request $request)
    {
        $date = date('Y-m-d');
        $jam = date('H:i'); 
        $hadir = new Hadir();
        $hadir->nama = $request->nama;
        $hadir->kode_member = $request->kode_member;
        $hadir->tanggal = $date;
        $hadir->jam = $jam;
        $hadir->status = $request->status;
        $hadir->status2 = $request->status2;
        $hadir->save();

      return redirect()->route('hadir.index')->with('presensi','Data Berhasil Ditambah');
    }

     public function hadir_hadir(Request $request)
    {
        if(!$request->ajax()) abort(404);
        $hasil = [];
        $spl = json_decode($request->layanan_id);
        $layanan_id = Member::where('kode_member', $spl)->get();
        $hasil = $layanan_id;
        return Response::json($hasil);
        // dd($iseng);
    }
}
